<?php

namespace Drupal\user_provisioning\ProviderSpecific\ResponseProcessor\UserResponseProcessor;

use Drupal\Component\Serialization\Json;
use Drupal\user_provisioning\Helpers\moUserProvisioningLogger;
use Drupal\user_provisioning\moUserProvisioningConstants;
use Drupal\user_provisioning\ProviderSpecific\ResponseProcessor\moResourceResponseProcessorInterface;
use Psr\Http\Message\ResponseInterface;

/**
 *
 */
class moUserAzureResponseProcessor implements moResourceResponseProcessorInterface {

    private moUserProvisioningLogger $mo_logger;

    public function __construct() {
        $this->mo_logger = new moUserProvisioningLogger();
    }

  /**
   * {@inheritDoc}
   */
  public function get(ResponseInterface $response) {
    $status_code = $response->getStatusCode();
    $content = $response->getBody()->getContents();
    $content_val = Json::decode($content);
    $user = $content_val['value'];

    // Initializing as conflict is not determined.
    $conflict = moUserProvisioningConstants::AZURE_CONFLICT_UNDETERMINED;
    if ($status_code == 200) {
      if (empty($user)) {
        // No conflict exists if no matching entity is found.
        $conflict = moUserProvisioningConstants::AZURE_NO_CONFLICT;
        $this->mo_logger->addLog('No matching user found, setting conflict status to AZURE_NO_CONFLICT.', __LINE__, __FUNCTION__, __FILE__);
      }
      else {
        // Setting as conflict since one or more entity at the configured application is matched with the requested query.
        $conflict = moUserProvisioningConstants::AZURE_CONFLICT;
        $this->mo_logger->addLog('User found, setting conflict status to AZURE_CONFLICT.', __LINE__, __FUNCTION__, __FILE__);
      }
    }
    return [$status_code, $content, $conflict];
  }

  /**
   * {@inheritDoc}
   */
  public function post(ResponseInterface $response) {
    $status_code = $response->getStatusCode();
    $content = $response->getBody()->getContents();
    return [$status_code, $content];
  }

  /**
   * {@inheritDoc}
   */
  public function patch(ResponseInterface $response) {
    // @todo Implement patch() method.
  }

  /**
   * {@inheritDoc}
   */
  public function put(ResponseInterface $response) {
    // @todo Implement put() method.
  }

  /**
   * {@inheritDoc}
   */
  public function delete(ResponseInterface $response) {
    // @todo Implement delete() method.
  }

  /**
   *
   */
  public function deactivate(ResponseInterface $response) {
    // @todo Implement deactivate() method.
  }

}
