<?php

namespace Drupal\user_provisioning\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\user_provisioning\moUserProvisioningConstants;
use Drupal\user_provisioning\moUserProvisioningUtilities;
use Drupal\Core\Url;

/**
 * Overview form for User Provisioning module.
 */
class MoOverview extends FormBase {

  private $base_url;

  /**
   * Constructor.
   */
  public function __construct() {
    $this->base_url = \Drupal::request()->getSchemeAndHttpHost() . \Drupal::request()->getBaseUrl();
  }

  /**
   * {@inheritDoc}
   */
  public function getFormId() {
    return "mo_overview";
  }

  /**
   * {@inheritDoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['mo_user_provisioning_overview_add_css'] = [
      '#attached' => [
        'library' => [
          'user_provisioning/user_provisioning.admin',
        ],
      ],
    ];

    $form['overview_header_style'] = [
      '#markup' => t('<div class="mo_user_provisioning_tab_heading">USER PROVISIONING & SYNCHRONIZATION</div><hr>'),
    ];

      $form['mo_user_provisioning_overview_intro'] = [
          '#markup' => t('
            <div class="mo-overview-intro">
              <p>
                This module manages user accounts across multiple applications from a central system. 
                It automates the <strong>creation</strong>, <strong>update</strong>, and <strong>removal</strong> of users to maintain consistency and 
                security across all connected platforms.
              </p>
        
                <ul>
                  <li><strong>SCIM-based Provisioning:</strong> Supports user provisioning through the SCIM 2.0 standard.</li>
                  <li><strong>API-based Provisioning:</strong> Enables direct integration and user synchronization using REST APIs with IdPs such as <strong>Okta</strong> and <strong>Azure AD</strong>.</li>
                  <li><strong>Audits and Logs:</strong> Records all provisioning activities for tracking and troubleshooting.</li>
                  <li><strong>Automatic and Manual Provisioning:</strong> Provides both real-time synchronization and on-demand user management.</li>
                  <li><strong>Attribute and Role Mapping:</strong> Supports mapping of user profile attributes and roles between Drupal and external systems.</li>
                </ul>

            </div>
          '),
      ];

      // Simple guides data for the template
      $guides_data = ['enabled' => true];


      $tabs_data = [
          [
              'title' => 'User Provisioning',
              'description' => 'Configure the connection with IdPs and manage user attributes and roles mapping.',
              'url' => Url::fromRoute('user_provisioning.provisioning')->toString(),
              'action' => 'User Provisioning',
          ],
          [
              'title' => 'Audits & Logs',
              'description' => 'View detailed records of all provisioning activities for monitoring and troubleshooting.',
              'url' => Url::fromRoute('user_provisioning.audits_and_logs')->toString(),
              'action' => 'Audits and Logs',
          ],
          [
              'title' => 'Advanced Settings',
              'description' => 'Import or export users using CSV or JSON files and enable debug logs for detailed analysis.',
              'url' => Url::fromRoute('user_provisioning.advanced_settings')->toString(),
              'action' => 'Advanced Settings',
          ],
      ];

      $form['tabs'] = [
          '#theme' => 'overview_tabs',
          '#tabs' => $tabs_data,
          '#guides' => $guides_data,
          '#all_guides_url' => 'https://plugins.miniorange.com/drupal/setup-guides?category=user-provisioning',
          '#video_id' => 'Tx_s3yJlyHs',
          '#video_title' => 'User Provisioning Setup Tutorial',
          '#video_description' => 'Learn how to configure and use the User Provisioning module in just a few minutes. This video covers the essential setup steps and key features.',
          '#youtube_url' => 'https://www.youtube.com/watch?v=Tx_s3yJlyHs&list=PL2vweZ-PcNpe9-BJQTgsVK5iDgDGdTCNc',
      ];

    moUserProvisioningUtilities::moProvShowCustomerSupportIcon($form, $form_state);

    return $form;
  }

  /**
   * {@inheritDoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // @todo Implement submitForm() method.
  }
}
