<?php

namespace Drupal\user_provisioning\ProviderSpecific\Factory;

use Drupal\user_provisioning\Helpers\moUserProvisioningLogger;
use Drupal\user_provisioning\moUserProvisioningConstants;
use Drupal\user_provisioning\ProviderSpecific\APIHandler\UserAPIHandler\moUserAzureAPIHandler;
use Drupal\user_provisioning\ProviderSpecific\APIHandler\UserAPIHandler\moUserOktaAPIHandler;
use Drupal\user_provisioning\ProviderSpecific\APIHandler\UserAPIHandler\moUserSCIMAPIHandler;
use Drupal\user_provisioning\ProviderSpecific\APIHandler\UserAPIHandler\moUserKeycloakAPIHandler;

use Drupal\user_provisioning\ProviderSpecific\Parsers\UserParser\moUserAzureParser;
use Drupal\user_provisioning\ProviderSpecific\Parsers\UserParser\moUserOktaParser;
use Drupal\user_provisioning\ProviderSpecific\Parsers\UserParser\moUserSCIMParser;
use Drupal\user_provisioning\ProviderSpecific\Parsers\UserParser\moUserKeycloakParser;

use Drupal\user_provisioning\ProviderSpecific\ResponseProcessor\UserResponseProcessor\moUserAzureResponseProcessor;
use Drupal\user_provisioning\ProviderSpecific\ResponseProcessor\UserResponseProcessor\moUserOktaResponseProcessor;
use Drupal\user_provisioning\ProviderSpecific\ResponseProcessor\UserResponseProcessor\moUserSCIMResponseProcessor;
use Drupal\user_provisioning\ProviderSpecific\ResponseProcessor\UserResponseProcessor\moUserKeycloakResponseProcessor;


/**
 *
 */
class moUserFactory implements moResourceFactoryInterface {

  private string $app_name;
  private moUserProvisioningLogger $mo_logger;

  /**
   *
   */
  public function __construct() {
    $app_name = \Drupal::config('user_provisioning.settings')->get('mo_user_provisioning_configured_application');
    if (empty($app_name)) {
      // FIXME uncomment the above line after saving the configured application name.
      $app_name = moUserProvisioningConstants::DEFAULT_APP;
    }
    $this->app_name = $app_name;
    $this->mo_logger = new moUserProvisioningLogger();
  }

  /**
   * {@inheritDoc}
   * */
  public function getAPIHandler() {
    if ($this->app_name == moUserProvisioningConstants::DEFAULT_APP) {
        $this->mo_logger->addLog('Returning moUserSCIMAPIHandler for app: ' . $this->app_name, __LINE__, __FUNCTION__, __FILE__);
      return new moUserSCIMAPIHandler();
    }
    elseif ($this->app_name == moUserProvisioningConstants::AZURE_AD) {
        $this->mo_logger->addLog('Returning moUserAzureAPIHandler for app: ' . $this->app_name, __LINE__, __FUNCTION__, __FILE__);
      return new moUserAzureAPIHandler();
    }
    elseif ($this->app_name == moUserProvisioningConstants::OKTA) {
        $this->mo_logger->addLog('Returning moUserOktaAPIHandler for app: ' . $this->app_name, __LINE__, __FUNCTION__, __FILE__);
      return new moUserOktaAPIHandler();
    }
    elseif($this->app_name == moUserProvisioningConstants::KEYCLOAK) {
        $this->mo_logger->addLog('Returning moUserKeycloakAPIHandler for app: ' . $this->app_name, __LINE__, __FUNCTION__, __FILE__);
        return new moUserKeycloakAPIHandler();
    }
  }

  /**
   * {@inheritDoc}
   * */
  public function getParser() {
    if ($this->app_name == moUserProvisioningConstants::DEFAULT_APP) {
        $this->mo_logger->addLog('Returning moUserSCIMParser for app: ' . $this->app_name, __LINE__, __FUNCTION__, __FILE__);
      return new moUserSCIMParser();
    }
    elseif ($this->app_name == moUserProvisioningConstants::AZURE_AD) {
        $this->mo_logger->addLog('Returning moUserAzureParser for app: ' . $this->app_name, __LINE__, __FUNCTION__, __FILE__);
        return new moUserAzureParser();
    }
    elseif ($this->app_name == moUserProvisioningConstants::OKTA) {
        $this->mo_logger->addLog('Returning moUserOktaParser for app: ' . $this->app_name, __LINE__, __FUNCTION__, __FILE__);
        return new moUserOktaParser();
    }
    elseif($this->app_name == moUserProvisioningConstants::KEYCLOAK) {
        $this->mo_logger->addLog('Returning moUserKeycloakParser for app: ' . $this->app_name, __LINE__, __FUNCTION__, __FILE__);
        return new moUserKeycloakParser();
    }
  }

  /**
   * {@inheritDoc}
   * */
  public function getResponseProcessor() {
    if ($this->app_name == moUserProvisioningConstants::DEFAULT_APP) {
        $this->mo_logger->addLog('Returning moUserSCIMResponseProcessor for app: ' . $this->app_name, __LINE__, __FUNCTION__, __FILE__);
      return new moUserSCIMResponseProcessor();
    }
    elseif ($this->app_name == moUserProvisioningConstants::AZURE_AD) {
        $this->mo_logger->addLog('Returning moUserAzureResponseProcessor for app: ' . $this->app_name, __LINE__, __FUNCTION__, __FILE__);
        return new moUserAzureResponseProcessor();
    }
    elseif ($this->app_name == moUserProvisioningConstants::OKTA) {
        $this->mo_logger->addLog('Returning moUserOktaResponseProcessor for app: ' . $this->app_name, __LINE__, __FUNCTION__, __FILE__);
        return new moUserOktaResponseProcessor();
    }
    elseif($this->app_name == moUserProvisioningConstants::KEYCLOAK) {
        $this->mo_logger->addLog('Returning moUserKeycloakResponseProcessor for app: ' . $this->app_name, __LINE__, __FUNCTION__, __FILE__);
        return new moUserKeycloakResponseProcessor();
    }
  }

}
