<?php

namespace Drupal\user_provisioning\ProviderSpecific\Parsers\UserParser;

use Drupal\Core\Config\Config;
use Drupal\Core\Config\ImmutableConfig;
use Drupal\Core\Entity\EntityInterface;
use Drupal\user_provisioning\Helpers\moUserProvisioningLogger;
use Drupal\user_provisioning\ProviderSpecific\Parsers\moResourceParserInterface;

class moUserKeycloakParser implements moResourceParserInterface
{
    private Config $config_factory;

    private ImmutableConfig $config;

    private ImmutableConfig $keycloak_config;

    private moUserProvisioningLogger $mo_logger;

    public function __construct() {
        $this->mo_logger = new moUserProvisioningLogger();
        $this->config_factory = \Drupal::configFactory()->getEditable('keycloak_user_provisioning.settings');
        $this->config = \Drupal::config('user_provisioning.settings');
        $this->keycloak_config = \Drupal::config('keycloak_user_provisioning.settings');
    }

    public function search($resource_id): string
    {
        $this->mo_logger->addLog('Create search request parameter', __LINE__, __FUNCTION__, __FILE__);
        return '?email=' . $resource_id;
    }

    #[\Override] public function get($resource_id)
    {
        // TODO: Implement get() method.
    }

    public function post(EntityInterface $entity)
    {
        $email = $entity->getEmail();

        $username = $entity->getAccountName();

        $first_name = $this->keycloak_config->get('keycloak_user_provisioning_basic_first_name_mapping');
        $first_name = !empty($first_name) ? $entity->get($first_name)->value : $entity->getDisplayName();
        $last_name = $this->keycloak_config->get('keycloak_user_provisioning_basic_last_name_mapping');
        $last_name = !empty($last_name) ? $entity->get($last_name)->value : $entity->getDisplayName();
        $enabled = $entity->isActive();

        // Prepare user data for Keycloak
        return $user_data = [
            "createdTimestamp" => round(microtime(true) * 1000),
            "username" => $username,
            "enabled" => $enabled,
            "totp" => false,
            "emailVerified" => true,
            "firstName" => $first_name,
            "lastName" => $last_name,
            "email" => $email,
            "disableableCredentialTypes" => [],
            "requiredActions" => [],
            "notBefore" => 0,
            "access" => [
                "manageGroupMembership" => true,
                "view" => true,
                "mapRoles" => true,
                "impersonate" => true,
                "manage" => true,
            ],
            "realmRoles" => ["mb-user"],
        ];
    }

    #[\Override] public function put(array $resource)
    {
        // TODO: Implement put() method.
    }

    #[\Override] public function patch(array $resource)
    {
        // TODO: Implement patch() method.
    }

    #[\Override] public function delete(array $resource)
    {
        // TODO: Implement delete() method.
    }

    #[\Override] public function deactivate(EntityInterface $entity)
    {
        // TODO: Implement deactivate() method.
    }
}