<?php

namespace Drupal\user_provisioning\ProviderSpecific\ResponseProcessor\UserResponseProcessor;

use Drupal\user_provisioning\Helpers\moUserProvisioningLogger;
use Drupal\user_provisioning\moUserProvisioningConstants;
use Drupal\user_provisioning\ProviderSpecific\ResponseProcessor\moResourceResponseProcessorInterface;
use Psr\Http\Message\ResponseInterface;

class moUserKeycloakResponseProcessor implements moResourceResponseProcessorInterface {

    protected moUserProvisioningLogger $mo_logger;

    public function __construct()
    {
        $this->mo_logger = new moUserProvisioningLogger();
    }


    public function get(ResponseInterface $response)
    {
        $status_code = $response->getStatusCode();
        $content = $response->getBody()->getContents();
        $conflict = moUserProvisioningConstants::KEYCLOAK_CONFLICT_UNDETERMINED;
        if($status_code == 200){
            $response = json_decode($content, TRUE);
            $user_id = NULL;
            if(isset($response[0]['id'])){
                $user_id = $response[0]['id'];
            }

            if(is_null($user_id)){
                $conflict = moUserProvisioningConstants::KEYCLOAK_NO_CONFLICT;
                $this->mo_logger->addLog('No matching user found, setting conflict status to KEYCLOAK_NO_CONFLICT.', __LINE__, __FUNCTION__, __FILE__);
            }
            else{
                $conflict = moUserProvisioningConstants::KEYCLOAK_CONFLICT;
                $this->mo_logger->addLog('User found, setting conflict status to KEYCLOAK_CONFLICT.', __LINE__, __FUNCTION__, __FILE__);
            }
        }
        return [$status_code,$content, $conflict];
    }

    public function post(ResponseInterface $response)
    {
        $status_code = $response->getStatusCode();
        $content = $response->getBody()->getContents();
        return [$status_code, $content];
    }

    #[\Override] public function patch(ResponseInterface $response)
    {
        // TODO: Implement patch() method.
    }

    #[\Override] public function put(ResponseInterface $response)
    {
        // TODO: Implement put() method.
    }

    #[\Override] public function delete(ResponseInterface $response)
    {
        // TODO: Implement delete() method.
    }

    #[\Override] public function deactivate(ResponseInterface $response)
    {
        // TODO: Implement deactivate() method.
    }
}
