<?php

namespace Drupal\user_reference_invite\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Drupal\Core\Url;

/**
 * Controller for accepting invitations.
 */
class InviteAcceptController extends ControllerBase {

  /**
   * Accept an invitation.
   */
  public function accept($token) {
    $invite_manager = \Drupal::service('user_reference_invite.invite_manager');
    $current_user = $this->currentUser();

    // If not logged in, redirect to login/register with token.
    if ($current_user->isAnonymous()) {
      $this->messenger()->addWarning($this->t('Please log in or register to accept this invitation.'));
      return new RedirectResponse(Url::fromRoute('user.register', [], [
        'query' => ['invite_token' => $token],
      ])->toString());
    }

    // User is logged in, try to accept.
    $user = $this->entityTypeManager()->getStorage('user')->load($current_user->id());

    if ($invite_manager->acceptInvitation($token, $user)) {
      $this->messenger()->addStatus($this->t('Invitation accepted successfully.'));
    }
    else {
      $this->messenger()->addError($this->t('Failed to accept invitation. It may be invalid or expired.'));
    }

    return $this->redirect('<front>');
  }

}
