<?php

namespace Drupal\user_reference_invite\EventSubscriber;

use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Drupal\user_reference_invite\Service\UserInviteManagerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Event subscriber for invitation cleanup via cron.
 */
class InviteCleanupSubscriber implements EventSubscriberInterface {

  /**
   * The invite manager.
   *
   * @var \Drupal\user_reference_invite\Service\UserInviteManagerInterface
   */
  protected $inviteManager;

  /**
   * The logger.
   *
   * @var \Psr\Log\LoggerInterface
   */
  protected $logger;

  /**
   * Constructs a new InviteCleanupSubscriber.
   */
  public function __construct(
    UserInviteManagerInterface $invite_manager,
    LoggerChannelFactoryInterface $logger_factory,
  ) {
    $this->inviteManager = $invite_manager;
    $this->logger = $logger_factory->get('user_reference_invite');
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    // Note: Drupal doesn't have a cron event by default.
    // We'll implement this via hook_cron in the .module file instead.
    return [];
  }

}
