<?php

namespace Drupal\user_reference_invite\Entity;

use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Provides an interface for user invitation entities.
 */
interface UserInviteInterface extends ContentEntityInterface {

  /**
   * Gets the invitation email address.
   *
   * @return string
   *   The email address.
   */
  public function getEmail();

  /**
   * Sets the invitation email address.
   *
   * @param string $email
   *   The email address.
   *
   * @return $this
   */
  public function setEmail($email);

  /**
   * Gets the invitation token.
   *
   * @return string
   *   The token.
   */
  public function getToken();

  /**
   * Sets the invitation token.
   *
   * @param string $token
   *   The token.
   *
   * @return $this
   */
  public function setToken($token);

  /**
   * Gets the invitation status.
   *
   * @return string
   *   The status (pending, accepted, expired, cancelled).
   */
  public function getStatus();

  /**
   * Sets the invitation status.
   *
   * @param string $status
   *   The status.
   *
   * @return $this
   */
  public function setStatus($status);

  /**
   * Checks if the invitation has expired.
   *
   * @return bool
   *   TRUE if expired, FALSE otherwise.
   */
  public function isExpired();

  /**
   * Checks if the invitation is pending.
   *
   * @return bool
   *   TRUE if pending, FALSE otherwise.
   */
  public function isPending();

  /**
   * Gets the entity type ID that this invitation is for.
   *
   * @return string
   *   The entity type ID.
   */
  public function getTargetEntityType();

  /**
   * Gets the entity ID that this invitation is for.
   *
   * @return int
   *   The entity ID.
   */
  public function getTargetEntityId();

  /**
   * Gets the field name that this invitation is for.
   *
   * @return string
   *   The field name.
   */
  public function getFieldName();

  /**
   * Gets the user who created this invitation.
   *
   * @return int
   *   The user ID.
   */
  public function getInvitedBy();

  /**
   * Gets the creation timestamp.
   *
   * @return int
   *   The timestamp.
   */
  public function getCreatedTime();

  /**
   * Gets the expiration timestamp.
   *
   * @return int
   *   The timestamp.
   */
  public function getExpiresTime();

}
