<?php

namespace Drupal\user_reference_invite\Form;

use Drupal\Core\Entity\ContentEntityConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Form for cancelling an invitation.
 */
class InviteCancelForm extends ContentEntityConfirmFormBase {

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to cancel this invitation?');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return new Url('user_reference_invite.admin.list');
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Cancel Invitation');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    /** @var \Drupal\user_reference_invite\Entity\UserInviteInterface $invite */
    $invite = $this->entity;
    $invite->setStatus('cancelled');
    $invite->save();

    $this->messenger()->addStatus($this->t('Invitation cancelled.'));
    $form_state->setRedirectUrl($this->getCancelUrl());
  }

}
