<?php

namespace Drupal\user_reference_invite\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Listens to the dynamic route events.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    // Replace access check for user.register route to allow invited users.
    if ($route = $collection->get('user.register')) {
      // Remove the default Drupal registration access check.
      $requirements = $route->getRequirements();
      unset($requirements['_access_user_register']);
      $route->setRequirements($requirements);

      // Add our custom access check that handles both
      // invites and standard registration.
      $route->setRequirement('_user_invite_register_access', 'TRUE');
      // Keep the anonymous user requirement.
      $route->setRequirement('_user_is_logged_in', 'FALSE');
    }
  }

}
