<?php

namespace Drupal\user_reference_invite\Service;

/**
 * Interface for the Token Service.
 */
interface TokenServiceInterface {

  /**
   * Generate a unique, secure token.
   *
   * @param string $email
   *   The email address.
   * @param array $context
   *   Additional context for token generation.
   *
   * @return string
   *   The generated token (plain, not hashed).
   */
  public function generateToken(string $email, array $context = []): string;

  /**
   * Hash a token for storage.
   *
   * @param string $token
   *   The plain token.
   *
   * @return string
   *   The hashed token.
   */
  public function hashToken(string $token): string;

  /**
   * Verify a token against its hash.
   *
   * @param string $token
   *   The plain token to verify.
   * @param string $hash
   *   The stored hash.
   *
   * @return bool
   *   TRUE if valid.
   */
  public function verifyToken(string $token, string $hash): bool;

}
