# Changelog

All notable changes to the User Invite Reference module will be documented in this file.

## [1.0.1-alpha2] - 2025-12-22

### Added
- **Configurable Table Columns**: Administrators can now customize which columns are displayed in invitation-related tables
  - Admin Invitations Table (`/admin/people/invitations`): 10 configurable columns (Email, Status, Entity, Field, Invited By, Created, Expires, Accepted Date, Accepted By, Roles)
  - Current Users Table (Field Widget): 5 configurable columns (Name, Email, Roles, Status, Last Access)
  - Pending Invitations Table (Field Widget): 5 configurable columns (Email, Sent, Expires, Invited By, Roles)
- **Table Display Settings**: New configuration section at `/admin/config/people/user-reference-invite`
  - Intuitive checkbox interface for column selection
  - Smart defaults for each table type
  - Required field validation (at least one column must be selected)
  - Configuration exportable via Drupal's configuration management
- **Dynamic Table Rendering**: Tables now dynamically generate headers and rows based on selected columns
- **Helper Methods**: Added column management methods across `InviteSettingsForm`, `UserReferenceInviteWidget`, and `InviteAdminController`

### Changed
- Tables now read column configuration from settings instead of using hardcoded columns
- Improved table rendering performance by loading only necessary columns
- Enhanced mobile responsiveness with fewer columns option

### Technical Details
- New configuration keys in `user_reference_invite.settings.yml`:
  - `admin_table_columns`
  - `current_users_table_columns`
  - `pending_invitations_table_columns`
- Updated configuration schema in `user_reference_invite.schema.yml`
- Modified `InviteSettingsForm::buildForm()` to add table display settings
- Modified `InviteSettingsForm::submitForm()` to save column selections
- Modified `UserReferenceInviteWidget::renderPendingInvites()` for dynamic columns
- Modified `UserReferenceInviteWidget::renderExistingUsers()` for dynamic columns
- Modified `InviteAdminController` for admin table column configuration
- Added helper methods: `getAvailableAdminColumns()`, `getAvailableCurrentUsersColumns()`, `getAvailablePendingInvitationsColumns()`, `getCurrentUserColumnValue()`, `getPendingInviteColumnValue()`

### Upgrade Path
1. Run `drush updb` to execute any update hooks
2. Run `drush cr` to clear cache
3. Visit `/admin/config/people/user-reference-invite` to review and customize table columns
4. Default columns are automatically configured for backward compatibility

## [1.0.0-alpha1] - Released - 2025-12-22

### Breaking Changes
- **Removed custom invitation message configuration**: The module no longer uses custom message fields in widget settings or module configuration. Email templates are now managed through Drupal's standard user account settings at `/admin/config/people/accounts`.

### Added
- **Multiple Email Invitations**: Support for comma-separated email addresses in the invite field
  - Enter multiple emails in a single textarea field (e.g., `user1@example.com, user2@example.com`)
  - Individual email validation for each address
  - Bulk invitation processing with success/failure tracking
  - "Add another item" button automatically hidden in invite mode
  - Simplified UI for inviting multiple users at once
- **Email Template Integration**: Full integration with Drupal's user.mail configuration system
- **Custom Token System**: Added `user_invite` token type with 8 custom tokens:
  - `[user_invite:invited_by]` - Inviter's name
  - `[user_invite:entity_label]` - Entity being invited to
  - `[user_invite:register_url]` - Registration URL
  - `[user_invite:login_url]` - Login URL
  - `[user_invite:accept_url]` - Direct acceptance URL
  - `[user_invite:expiry_date]` - Expiration date
  - `[user_invite:email]` - Invited user's email
  - `[user_invite:roles]` - Assigned roles
- **HTML Mail Support**: Automatic HTML email support when htmlmail, swiftmailer, or symfony_mailer modules are enabled
- **Token Browser**: Integration with Token module for easy token insertion
- **User Account Settings Integration**: Added "User Invitation" section to `/admin/config/people/accounts`
- **Update Hook**: `user_reference_invite_update_9001()` for automatic migration from old configuration

### Changed
- Email templates are now configured at `/admin/config/people/accounts` instead of field widget settings
- Email subject and body now support full token replacement
- Widget settings simplified - removed `invitation_message_template` field
- Configuration schema updated to remove `custom_message_enabled` and `custom_message_default`

### Removed
- `custom_message_enabled` configuration setting
- `custom_message_default` configuration setting
- `invitation_message_template` widget setting
- `custom_message` parameter from email sending
- `custom_message` variable from `user_invite_notification` theme

### Technical Details
- Implements `hook_form_user_admin_settings_alter()` to add email template fields
- Implements `hook_token_info()` to define custom tokens
- Implements `hook_tokens()` to provide token replacements
- Updated `hook_mail_alter()` to process email templates with token replacement
- Simplified `hook_mail()` to delegate to hook_mail_alter()
- Updated `hook_theme()` to remove custom_message variable
- Added cleanup in `hook_uninstall()` to remove email templates

### Upgrade Path
1. Run `drush updb` to execute update hook
2. Visit `/admin/config/people/accounts` to configure email templates
3. Manually migrate any custom messages to the new template system
4. Test invitation emails to ensure proper token replacement

## [1.0.0] - Initial Release

### Added
- User reference field widget with invitation capability
- Secure token-based invitation system
- Auto-attachment on user registration
- Role assignment for invited users
- Admin interface for invitation management
- Email notifications
- Rate limiting and expiration
- Cron-based cleanup
