# Contributing to User Invite & Reference

Thank you for considering contributing to this project! This document outlines
the process and guidelines for contributing.

## Code of Conduct

This project adheres to the [Drupal Code of Conduct](https://www.drupal.org/dcoc).
By participating, you are expected to uphold this code.

## How Can I Contribute?

### Reporting Bugs

Before creating bug reports, please check the issue queue to avoid duplicates.

When creating a bug report, please include:
- **Drupal version** (10.x or 11.x)
- **Module version**
- **PHP version**
- **Steps to reproduce** the behavior
- **Expected behavior**
- **Actual behavior**
- **Screenshots** if applicable
- **Error messages** from logs

### Suggesting Enhancements

Enhancement suggestions are tracked as issues. When creating an
enhancement suggestion, include:
- **Use case** - Why is this enhancement needed?
- **Proposed solution** - How would you implement it?
- **Alternatives considered** - What other solutions did you consider?
- **Additional context** - Screenshots, mockups, etc.

### Code Contributions

1. **Fork the repository** (if using Git) or create a patch
2. **Create a branch** for your feature/fix
3. **Follow Drupal coding standards**:
   - Run `phpcs --standard=Drupal,DrupalPractice web/modules/custom/user_reference_invite`
   - Fix issues with `phpcbf`
4. **Write tests** for new functionality
5. **Update documentation** if needed
6. **Submit a patch** or **merge request**

#### Coding Standards

- Follow [Drupal Coding Standards](https://www.drupal.org/docs/develop/standards)
- Use meaningful variable and function names
- Comment complex logic
- Keep functions focused and small
- Write PHPDoc blocks for all public methods

#### Commit Messages

- Use the present tense ("Add feature" not "Added feature")
- Use the imperative mood ("Move cursor to..." not "Moves cursor to...")
- Reference issue numbers: "Issue #123: Add feature description"
- First line should be a summary (50 chars or less)
- Provide detailed description in subsequent lines

Example:
```
Issue #123: Add bulk invitation upload feature

- Implemented CSV upload form
- Added validation for email format
- Created batch process for large files
- Updated documentation
```

### Pull Request Process

1. Ensure all tests pass
2. Update README.md with new features/changes
3. Increase version numbers following [Semantic Versioning](https://semver.org/)
4. The PR will be merged once it receives approval from maintainers

## Development Setup

```bash
# Install Drupal with Composer
composer install

# Enable the module
drush en user_reference_invite

# Run coding standards check
phpcs --standard=Drupal,DrupalPractice web/modules/custom/user_reference_invite

# Auto-fix coding standards issues
phpcbf --standard=Drupal,DrupalPractice web/modules/custom/user_reference_invite

# Run tests (if available)
php core/scripts/run-tests.sh --module user_reference_invite
```

## Testing Guidelines

- Write unit tests for services and business logic
- Write kernel tests for database operations
- Write functional tests for user-facing features
- Ensure all tests pass before submitting

## Documentation

- Update README.md for user-facing changes
- Add change notes to CHANGELOG.md
- Update help text if applicable
- Document API changes in code comments

## Questions?

- **Issue queue**: https://www.drupal.org/project/issues/user_reference_invite
- **Drupal Slack**: Join the #contribute channel

## Recognition

Contributors will be credited in:
- Module project page
- Release notes
- CHANGELOG.md

Thank you for contributing! 🎉
