/**
 * @file
 * JavaScript for User Invite Reference widget.
 */

(function ($, Drupal, once) {
  'use strict';

  /**
   * Toggle visibility of "Add another item" button based on mode selection.
   */
  Drupal.behaviors.userInviteWidget = {
    attach: function (context, settings) {
      // Find all user invite field wrappers.
      var wrappers = once('user-invite-widget', '.user-invite-field-wrapper', context);
      wrappers.forEach(function (wrapper) {
        var $wrapper = $(wrapper);
        var $modeRadios = $wrapper.find('input[name*="[mode]"]');

        // Function to update button visibility.
        var updateButtonVisibility = function () {
          var selectedMode = $modeRadios.filter(':checked').val();
          var $fieldWrapper = $wrapper.closest('.field--widget-user-reference-invite');
          var $addMoreButton = $fieldWrapper.find('.field-add-more-submit');

          if (selectedMode === 'invite') {
            // Hide "Add another item" button in invite mode.
            $addMoreButton.hide();
            $fieldWrapper.addClass('invite-mode');
          } else {
            // Show "Add another item" button in existing user mode.
            $addMoreButton.show();
            $fieldWrapper.removeClass('invite-mode');
          }
        };

        // Update on radio button change.
        $modeRadios.on('change', updateButtonVisibility);

        // Initial update.
        updateButtonVisibility();
      });
    }
  };

})(jQuery, Drupal, once);
