<?php

namespace Drupal\user_reference_invite\EventSubscriber;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Messenger\MessengerInterface;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Drupal\Core\TempStore\PrivateTempStoreFactory;
use Drupal\user_reference_invite\Service\UserInviteManagerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Event subscriber for user registration.
 */
class UserRegistrationSubscriber implements EventSubscriberInterface {

  /**
   * The invite manager.
   *
   * @var \Drupal\user_reference_invite\Service\UserInviteManagerInterface
   */
  protected $inviteManager;

  /**
   * The messenger.
   *
   * @var \Drupal\Core\Messenger\MessengerInterface
   */
  protected $messenger;

  /**
   * The logger.
   *
   * @var \Psr\Log\LoggerInterface
   */
  protected $logger;

  /**
   * The temp store.
   *
   * @var \Drupal\Core\TempStore\PrivateTempStoreFactory
   */
  protected $tempStore;

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * Constructs a new UserRegistrationSubscriber.
   */
  public function __construct(
    UserInviteManagerInterface $invite_manager,
    MessengerInterface $messenger,
    LoggerChannelFactoryInterface $logger_factory,
    PrivateTempStoreFactory $temp_store,
    EntityTypeManagerInterface $entity_type_manager,
  ) {
    $this->inviteManager = $invite_manager;
    $this->messenger = $messenger;
    $this->logger = $logger_factory->get('user_reference_invite');
    $this->tempStore = $temp_store;
    $this->entityTypeManager = $entity_type_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      KernelEvents::REQUEST => ['onRequest', 50],
    ];
  }

  /**
   * Store invitation token from URL in session.
   */
  public function onRequest(RequestEvent $event) {
    $request = $event->getRequest();
    $token = $request->query->get('invite_token');

    if ($token) {
      // Store token in session for post-registration processing.
      $store = $this->tempStore->get('user_reference_invite');
      $store->set('pending_invite_token', $token);
    }
  }

}
