<?php

namespace Drupal\user_restrictions\Annotation;

use Drupal\Component\Annotation\Plugin;
use Drupal\Core\Annotation\Translation;

/**
 * Defines the annotation object for UserRestrictionType plugins.
 *
 * @see \Drupal\user_restrictions\Plugin\UserRestrictionTypeManager
 * @see plugin_api
 *
 * @Annotation
 */
class UserRestrictionType extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public string $id;

  /**
   * The plugin label.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public Translation $label;

  /**
   * The plugin weight.
   *
   * @var int
   */
  public int $weight;

}
