<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUndefinedNamespaceInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUnused */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions\Controller;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Messenger\MessengerTrait;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\user_restrictions\Entity\UserRestrictionInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Controller for user restriction operations.
 */
class UserRestrictionsController implements ContainerInjectionInterface {

  use MessengerTrait;
  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): self {
    $instance = new static();
    $instance->setMessenger($container->get('messenger'));
    $instance->setStringTranslation($container->get('string_translation'));

    return $instance;
  }

  /**
   * Performs an operation on a user restriction entity.
   *
   * @param \Drupal\user_restrictions\Entity\UserRestrictionInterface $user_restrictions
   *   The user restriction entity.
   * @param string $op
   *   The operation to perform.
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse
   *   A redirect back to the user restriction collection page.
   *
   * @throws \Drupal\Core\Entity\EntityMalformedException
   *   The entity is malformed.
   */
  public function performOperation(UserRestrictionInterface $user_restrictions, string $op): RedirectResponse {
    $user_restrictions->$op()->save();

    $message = match($op) {
      'enable' => $this->t('The user restriction %label has been enabled.', [
        '%label' => $user_restrictions->label(),
      ]),
      'disable' => $this->t('The user restriction %label has been disabled.', [
        '%label' => $user_restrictions->label(),
      ]),
    };

    if ($message) {
      $this->messenger()->addStatus($message);
    }

    return new RedirectResponse($user_restrictions->toUrl('collection')->toString());
  }

}
