<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUnused */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions\Form;

use Drupal\Core\Form\FormStateInterface;

/**
 * Provides the form to create a new user restriction.
 *
 * @internal
 */
class UserRestrictionsAddForm extends UserRestrictionsEditForm {

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    parent::submitForm($form, $form_state);
    $this->messenger()
      ->addStatus($this->t('User restriction %label has been created.', ['%label' => $this->entity->label()]));
    // Redirect to the user restriction collection page.
    $form_state->setRedirect('entity.user_restrictions.collection');
  }

  /**
   * {@inheritdoc}
   */
  public function actions(array $form, FormStateInterface $form_state): array {
    $actions = parent::actions($form, $form_state);
    $actions['submit']['#value'] = $this->t('Add user restriction');

    return $actions;
  }

}
