<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUndefinedNamespaceInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUnused */
/** @noinspection PhpUnusedParameterInspection */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\user_restrictions\UserRestrictionsManagerInterface;

/**
 * Hook implementations for the User Restrictions module.
 */
readonly class UserRestrictionsCronHooks {

  // phpcs:disable Drupal.Files.LineLength.TooLong

  /**
   * Constructs a new \Drupal\user_restrictions\Hook\UserRestrictionsCronHooks instance.
   *
   * @param \Drupal\user_restrictions\UserRestrictionsManagerInterface $restrictionManager
   *   The user restrictions manager.
   */
  public function __construct(
    protected UserRestrictionsManagerInterface $restrictionManager,
  ) {}

  // phpcs:enable

  /**
   * Implements hook_cron().
   *
   * @phpstan-ignore-next-line
   */
  #[Hook('cron')]
  public function cron(): void {
    $this->restrictionManager->deleteExpiredRules();
  }

}
