<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpMissingParamTypeInspection */
/** @noinspection PhpUnused */
/** @noinspection PhpUnusedParameterInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUndefinedNamespaceInspection */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions\Plugin\UserRestrictionType;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\user_restrictions\Attribute\UserRestrictionType;
use Drupal\user_restrictions\Entity\UserRestrictionInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\RequestStack;

/**
 * Defines a restriction type for the client IP.
 */
#[UserRestrictionType(
  id: 'user_restrictions_client_ip',
  label: new TranslatableMarkup('Client IP'),
)]
class ClientIp extends UserRestrictionTypeBase {

  /**
   * The request stack.
   *
   * @var \Symfony\Component\HttpFoundation\RequestStack
   */
  protected RequestStack $requestStack;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->requestStack = $container->get('request_stack');

    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function buildData(array $form, FormStateInterface $form_state, string $form_id, string $type = 'string'): string|object|null {
    $client_ip = $this->requestStack->getCurrentRequest()->getClientIp();

    $this->setLogMessage([
      'Restricted client IP %client_ip matching %restriction has been blocked.',
      ['%client_ip' => $client_ip],
    ]);
    $this->setErrorMessage($this->t(
      'Accessing the site from the IP %value is not allowed.',
      ['%value' => $client_ip]
    ));

    return match($type) {
      'object' => (object) ['ip' => $client_ip],
      'string' => $client_ip,
      default => NULL,
    };
  }

  /**
   * {@inheritdoc}
   */
  public function matches(array $data, string $form_id = ''): false|UserRestrictionInterface {
    @trigger_error('The ' . __METHOD__ . ' method is deprecated in user_restrictions:2.1.1 and is removed from user_restrictions:3.0.0. Use the ' . __CLASS__ . '::buildData() method instead. See https://www.drupal.org/node/3555586', E_USER_DEPRECATED);

    return FALSE;
  }

}
