<?php

namespace Drupal\user_restrictions\Plugin\UserRestrictionType;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\user_restrictions\Attribute\UserRestrictionType;
use Drupal\user_restrictions\Entity\UserRestrictionInterface;

/**
 * Defines a restriction type for usernames.
 */
#[UserRestrictionType(
  id: 'name',
  label: new TranslatableMarkup('Username'),
)]
class Name extends UserRestrictionTypeBase {

  /**
   * {@inheritdoc}
   */
  public function buildData(array $form, FormStateInterface $form_state, string $form_id, string $type = 'string'): string|object|null {
    $name = $form_state->getValue('name');

    $this->setLogMessage([
      'Restricted name %name matching %restriction has been blocked.',
      ['%name' => $name],
    ]);
    $this->setErrorMessage($this->t(
      'The name %name is reserved, and cannot be used.',
      ['%name' => $name]
    ));

    return match($type) {
      'object' => (object) ['name' => $name],
      'string' => $name,
      default => NULL,
    };
  }

  /**
   * {@inheritdoc}
   */
  public function matches(array $data, string $form_id = ''): false|UserRestrictionInterface {
    @trigger_error('The ' . __METHOD__ . ' method is deprecated in user_restrictions:2.1.1 and is removed from user_restrictions:3.0.0. Use the ' . __CLASS__ . '::buildData() method instead. See https://www.drupal.org/node/3555586', E_USER_DEPRECATED);

    return FALSE;
  }

}
