<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpMissingParamTypeInspection */
/** @noinspection PhpUnused */
/** @noinspection PhpUnusedParameterInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUndefinedNamespaceInspection */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions\Plugin\UserRestrictionType;

use Drupal\Component\Datetime\TimeInterface;
use Drupal\Core\Entity\EntityStorageInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\user_restrictions\Entity\UserRestrictionInterface;
use Drupal\user_restrictions\Plugin\UserRestrictionTypeInterface;
use Psr\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Base class for user restriction types.
 */
abstract class UserRestrictionTypeBase extends PluginBase implements UserRestrictionTypeInterface {

  use StringTranslationTrait;

  /**
   * The entity storage.
   *
   * @var \Drupal\Core\Entity\EntityStorageInterface
   */
  protected EntityStorageInterface $entityStorage;

  /**
   * The list of patterns for the restriction.
   *
   * @var string[]
   *
   * @deprecated in user_restrictions:2.1.1 and is removed from
   *   user_restrictions:3.0.0. There is no replacement.
   *
   * @see https://www.drupal.org/node/3553215
   */
  protected array $patterns = [];

  /**
   * The log message.
   *
   * @var array
   */
  protected array $logMessage = [];

  /**
   * The error message.
   *
   * @var \Drupal\Core\StringTranslation\TranslatableMarkup|null
   */
  protected ?TranslatableMarkup $errorMessage = NULL;

  // phpcs:disable Drupal.Files.LineLength.TooLong

  /**
   * Constructs a new \Drupal\user_restrictions\Plugin\UserRestrictionType\UserRestrictionTypeBase instance.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param array $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_manager
   *   The entity storage.
   * @param \Psr\Log\LoggerInterface $logger
   *   The logger instance.
   * @param \Drupal\Component\Datetime\TimeInterface $time
   *   The time service.
   *
   * @throws \Drupal\Component\Plugin\Exception\InvalidPluginDefinitionException
   *   The storage handler could not be loaded.
   * @throws \Drupal\Component\Plugin\Exception\PluginNotFoundException
   *   The entity type does not exist.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    EntityTypeManagerInterface $entity_manager,
    protected LoggerInterface $logger,
    protected TimeInterface $time,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);

    $this->entityStorage = $entity_manager->getStorage('user_restrictions');
  }

  // phpcs:enable

  /**
   * {@inheritdoc}
   *
   * @throws \Drupal\Component\Plugin\Exception\InvalidPluginDefinitionException
   *   The storage handler could not be loaded.
   * @throws \Drupal\Component\Plugin\Exception\PluginNotFoundException
   *   The entity type does not exist.
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('entity_type.manager'),
      $container->get('logger.channel.user_restrictions'),
      $container->get('datetime.time'),
    );
  }

  /**
   * Checks if the specified value matches the restriction.
   *
   * @param string $value
   *   String to check against all restrictions of the type.
   * @param string $form_id
   *   The form to which the restriction is applied.
   *
   * @return bool|\Drupal\user_restrictions\Entity\UserRestrictionInterface
   *   The restriction entity if the value matches one of the restrictions,
   *   FALSE otherwise.
   *
   * @deprecated in user_restrictions:2.1.1 and is removed from
   *   user_restrictions:3.0.0. There is no replacement.
   *
   * @see https://www.drupal.org/node/3555646
   */
  protected function matchesValue(string $value, string $form_id = ''): bool|UserRestrictionInterface {
    @trigger_error('The ' . __METHOD__ . '() method is deprecated in user_restriction:2.1.1 and is removed from user_restrictions:3.0.0. There is no replacement. See https://www.drupal.org/node/3555646', E_USER_DEPRECATED);

    return FALSE;
  }

  /**
   * {@inheritdoc}
   *
   * @noinspection PhpDeprecationInspection
   */
  public function getPatterns(): array {
    @trigger_error('The ' . __METHOD__ . '() method is deprecated in user_restriction:2.1.1 and is removed from user_restrictions:3.0.0. There is no replacement. See https://www.drupal.org/node/3553215', E_USER_DEPRECATED);

    if (!empty($this->patterns)) {
      return $this->patterns;
    }

    $restrictions = $this->entityStorage
      ->loadByProperties(['plugin' => $this->getPluginId()]);

    if (empty($restrictions)) {
      return [];
    }

    /** @var \Drupal\user_restrictions\Entity\UserRestrictions $restriction */
    foreach ($restrictions as $id => $restriction) {
      $this->patterns[$id] = $restriction->getPattern();
    }

    return $this->patterns;
  }

  /**
   * {@inheritdoc}
   */
  public function getLabel(): TranslatableMarkup {
    return $this->pluginDefinition['label'];
  }

  /**
   * Sets the log message used when the entered value is not allowed.
   *
   * @param array $message
   *   The log message.
   */
  protected function setLogMessage(array $message): void {
    $this->logMessage = $message;
  }

  /**
   * {@inheritdoc}
   */
  public function getLogMessage(): array {
    return $this->logMessage;
  }

  /**
   * Sets the error message shown when the entered value is not allowed.
   *
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $message
   *   The error message.
   */
  protected function setErrorMessage(TranslatableMarkup $message): void {
    $this->errorMessage = $message;
  }

  /**
   * {@inheritdoc}
   */
  public function getErrorMessage(): ?TranslatableMarkup {
    return $this->errorMessage;
  }

}
