<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions\Plugin;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\user_restrictions\Entity\UserRestrictionInterface;

/**
 * Defines the interface for UserRestrictionType plugins.
 */
interface UserRestrictionTypeInterface extends ContainerFactoryPluginInterface {

  /**
   * Builds the data checked against user restrictions.
   *
   * @param array $form
   *   The form to which the restriction is applied.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   * @param string $form_id
   *   The form ID.
   * @param string $type
   *   The type of data to build.
   *
   * @return string|object|null
   *   The built data, or NULL if the required data is not handled by the
   *   plugin.
   */
  public function buildData(array $form, FormStateInterface $form_state, string $form_id, string $type = 'string'): string|object|null;

  /**
   * Check if the given data matches the restriction.
   *
   * @param array $data
   *   Data to check.
   * @param string $form_id
   *   The form to which the restriction is applied.
   *
   * @return bool|\Drupal\user_restrictions\Entity\UserRestrictionInterface
   *   TRUE if the value matches one of the restrictions, FALSE otherwise.
   *
   * @deprecated in user_restrictions:2.1.1 and is removed from
   *   user_restrictions:3.0.0. Instead, plugins must implement the buildData()
   *   method.
   *
   * @see https://www.drupal.org/node/3555586
   */
  public function matches(array $data, string $form_id): false|UserRestrictionInterface;

  /**
   * Get the list of regular expression patterns of the type.
   *
   * @return string[]
   *   Array with regular expression patterns.
   *
   * @deprecated in user_restrictions:2.1.1 and is removed from
   *   user_restrictions:3.0.0. There is no replacement.
   *
   * @see https://www.drupal.org/node/3553215
   */
  public function getPatterns(): array;

  /**
   * Get the plugin label.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup
   *   The plugin label.
   */
  public function getLabel(): TranslatableMarkup;

  /**
   * Gets the message logged when the entered value is not allowed.
   *
   * @return array
   *   The log message.
   */
  public function getLogMessage(): array;

  /**
   * Gets the error message shown when the entered value is not allowed.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup|null
   *   The error message.
   */
  public function getErrorMessage(): ?TranslatableMarkup;

}
