<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpMissingParamTypeInspection */
/** @noinspection PhpUnused */
/** @noinspection PhpUnusedParameterInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUndefinedNamespaceInspection */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions;

use Drupal\Component\Plugin\Exception\PluginException;
use Drupal\Component\Utility\SortArray;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\user_restrictions\Annotation\UserRestrictionType;
use Drupal\user_restrictions\Plugin\UserRestrictionTypeInterface;

/**
 * Manages user restriction type plugins.
 *
 * @internal
 */
class UserRestrictionTypeManager extends DefaultPluginManager implements UserRestrictionTypeManagerInterface {

  // phpcs:disable Drupal.Files.LineLength.TooLong

  /**
   * Constructs a new \Drupal\user_restrictions\UserRestrictionTypeManager instance.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(
    \Traversable $namespaces,
    CacheBackendInterface $cache_backend,
    ModuleHandlerInterface $module_handler,
  ) {
    parent::__construct('Plugin/UserRestrictionType', $namespaces, $module_handler, UserRestrictionTypeInterface::class, UserRestrictionType::class);
    $this->alterInfo('user_restriction_type_info');
    $this->setCacheBackend($cache_backend, 'user_restriction_type_plugins');
  }

  // phpcs:enable

  /**
   * {@inheritdoc}
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   *   An error happened when creating a plugin instance.
   */
  public function getTypes(): array {
    @trigger_error('The ' . __METHOD__ . ' method is deprecated in user_restrictions:2.1.1 and is removed in user_restrictions:3.0.0. There is not replacement. See https://www.drupal.org/node/3555443', E_USER_DEPRECATED);

    $instances = [];
    $plugins = $this->getDefinitions();

    uasort($plugins, fn($a, $b) => SortArray::sortByKeyString($a, $b, 'id'));

    foreach ($plugins as $id => $plugin) {
      $instances[$id] = $this->createInstance($id, $plugin);
    }

    return $instances;
  }

  /**
   * {@inheritdoc}
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   *   An error happened when creating a plugin instance.
   */
  public function getType($id): object {
    @trigger_error('The ' . __METHOD__ . ' method is deprecated in user_restrictions:2.1.1 and is removed in user_restrictions:3.0.0. There is not replacement. See https://www.drupal.org/node/3555443', E_USER_DEPRECATED);

    $plugins = $this->getDefinitions();

    if (!isset($plugins[$id])) {
      throw new PluginException("The user restriction type '$id' does not exist.");
    }

    return $this->createInstance($id, $plugins[$id]);
  }

  /**
   * {@inheritdoc}
   */
  public function getTypesAsOptions(): array {
    $options = [];
    $plugins = $this->getDefinitions();

    uasort($plugins, fn($a, $b) => SortArray::sortByKeyString($a, $b, 'id'));

    foreach ($plugins as $key => $definition) {
      $options[$key] = $definition['label'];
    }

    return $options;
  }

}
