<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpMissingParamTypeInspection */
/** @noinspection PhpUnused */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions;

/**
 * Defines the interface for the UserRestrictionTypeManager.
 */
interface UserRestrictionTypeManagerInterface {

  /**
   * Gets a list of all the registered user restriction types.
   *
   * @return \Drupal\user_restrictions\Plugin\UserRestrictionTypeInterface[]
   *   A list of user restriction types.
   *
   * @deprecated in user_restrictions:2.1.1 and is removed from
   *   user_restrictions:3.0.0. There is no replacement.
   *
   * @see https://www.drupal.org/node/3555443
   */
  public function getTypes(): array;

  /**
   * Gets a single plugin instance.
   *
   * @param string $id
   *   The plugin ID.
   *
   * @return \Drupal\user_restrictions\Plugin\UserRestrictionTypeInterface
   *   The plugin instance.
   *
   * @deprecated in user_restrictions:2.1.1 and is removed from
   *   user_restrictions:3.0.0. There is no replacement.
   *
   * @see https://www.drupal.org/node/3555443
   */
  public function getType($id): object;

  /**
   * Gets a list of plugin names for option lists.
   *
   * @return array
   *   A list of plugin names, keyed by plugin ID.
   */
  public function getTypesAsOptions(): array;

}
