<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUnused */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions;

use Drupal\Component\Plugin\Exception\PluginException;
use Drupal\Core\DependencyInjection\AutowireTrait;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Plugin\DefaultSingleLazyPluginCollection;

/**
 * Provides a collection of user restriction type plugins.
 */
class UserRestrictionTypePluginCollection extends DefaultSingleLazyPluginCollection implements ContainerInjectionInterface {

  use AutowireTrait;

  /**
   * The ID of the user restriction to which the collection belongs.
   *
   * @var string
   */
  protected string $restrictionId;

  // phpcs:disable Drupal.Files.LineLength.TooLong

  /**
   * Constructs a new \Drupal\user_restrictions\UserRestrictionTypePluginCollection instance.
   *
   * @param \Drupal\user_restrictions\UserRestrictionTypeManagerInterface $plugin_manager
   *   The plugin manager.
   *
   * @noinspection PhpMissingParentConstructorInspection
   */
  public function __construct(UserRestrictionTypeManagerInterface $plugin_manager) {
    // The parent constructor is not called on purpose.
    $this->manager = $plugin_manager;
  }

  // phpcs:enable

  /**
   * Initializes the plugin collection.
   *
   * @param string $instance_id
   *   The ID of the instance to add to the collection.
   * @param string $restriction_id
   *   The ID of the user restriction to which the collection belongs.
   * @param array $configuration
   *   The configuration of the plugin collection.
   *
   * @return $this
   */
  public function initializeCollection(string $instance_id, string $restriction_id, array $configuration = []): self {
    $this->restrictionId = $restriction_id;
    parent::addInstanceId($instance_id, $configuration);

    return $this;
  }

  /**
   * {@inheritdoc}
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   *   The instance ID is empty or another error occurred.
   */
  protected function initializePlugin($instance_id): void {
    if (!$instance_id) {
      throw new PluginException("The user restriction '$this->restrictionId' did not specify a type plugin.");
    }

    parent::initializePlugin($instance_id);
  }

}
