<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpMissingParamTypeInspection */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions;

use Drupal\Core\Form\FormStateInterface;

/**
 * Defines the UserRestrictionManager interface.
 */
interface UserRestrictionsManagerInterface {

  /**
   * Checks if a given data matches any restriction.
   *
   * @param array $form
   *   The form to which the restriction is applied.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   * @param string $form_id
   *   The form ID.
   *
   * @return bool
   *   TRUE if the data matches a restriction, FALSE otherwise.
   */
  public function matchesRestrictions(array $form, FormStateInterface $form_state, string $form_id): bool;

  /**
   * Deletes expired rules.
   *
   * @return $this
   */
  public function deleteExpiredRules(): self;

  /**
   * Gets all the error messages.
   *
   * @return string[]
   *   A list of error messages, keyed by the restriction type.
   */
  public function getErrors(): array;

}
