<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUndefinedNamespaceInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUnused */
/** @noinspection PhpFullyQualifiedNameUsageInspection */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines an attribute for user restriction type plugins.
 *
 * A user restriction type plugin defines a restriction for values which can be
 * entered for a user account, for example the allowed username, the allowed
 * domain for the email, or the IP address from which it is possible to log in.
 *
 * Plugin Namespace: Plugin\UserRestrictionType
 *
 * For a working example, see
 * \Drupal\user_restrictions\Plugin\UserRestrictionType\Name.
 *
 * @see \Drupal\user_restrictions\Plugin\UserRestrictionType\UserRestrictionTypeInterface
 * @see \Drupal\user_restrictions\Plugin\UserRestrictionType\UserRestrictionTypeBase
 * @see \Drupal\user_restrictions\UserRestrictionTypeManager
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class UserRestrictionType extends Plugin {

  // phpcs:disable Drupal.Files.LineLength.TooLong

  /**
   * Constructs a new \Drupal\user_restrictions\Attribute\UserRestrictionType instance.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The plugin label.
   * @param int|null $weight
   *   (optional) The plugin weight.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   *
   * @noinspection PhpMissingParentConstructorInspection
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly ?int $weight = NULL,
    public readonly ?string $deriver = NULL,
  ) {}

  // phpcs:enable
}
