<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUndefinedNamespaceInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUnused */
/** @noinspection PhpUnusedParameterInspection */
/** @noinspection PhpFullyQualifiedNameUsageInspection */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\StringTranslation\TranslationInterface;
use Drupal\Core\Url;

/**
 * Hook implementations for the User Restrictions module.
 */
class UserRestrictionsHelpHooks {

  use StringTranslationTrait;

  // phpcs:disable Drupal.Files.LineLength.TooLong

  /**
   * Constructs a new \Drupal\user_restrictions\Hook\UserRestrictionsHelpHooks instance.
   *
   * @param \Drupal\Core\StringTranslation\TranslationInterface $string_translation
   *   The string translation service.
   */
  public function __construct(TranslationInterface $string_translation) {
    $this->setStringTranslation($string_translation);
  }

  // phpcs:enable

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help($route_name, RouteMatchInterface $route_match): ?string {
    switch ($route_name) {
      case 'help.page.user_restrictions':
        $output = '<h2>' . $this->t('About') . '</h2>';
        $output .= '<p>' . $this->t("The User Restrictions module allows administrators to specify restrictions for usernames, email addresses, IP addresses, or other user account's values.") . '</p>';
        $output .= '<h2>' . $this->t('Uses') . '</h2>';
        $output .= '<dl>';
        $output .= '<dt>' . $this->t("Adding restrictions to user accounts' values") . '</dt>';
        $output .= '<dd>' . $this->t('Administrators can enter restrictions on the <a href=":restrictions">User restrictions</a> page.', [':restrictions' => Url::fromRoute('entity.user_restriction.collection')]) . '</dd>';
        $output .= '</dl>';
        return $output;

      case 'entity.user_restriction.collection':
        return '<p>' . $this->t("Set up restrictions for allowed usernames, email addresses, or IP addresses. A restriction may either explicitly allow access or deny access; it also apply to one or more user account forms.") . '</p>';
    }

    return NULL;
  }

}
