<?php

namespace Drupal\user_restrictions;

/**
 * The interface for user restriction entities.
 */
interface UserRestrictionInterface {

  /**
   * The pattern type for allowing an entered value.
   */
  public const int PATTERN_ALLOW = 1;

  /**
   * Gets the restriction type.
   *
   * @see \Drupal\user_restrictions\Plugin\UserRestrictionTypeInterface
   *
   * @return string
   *   The restriction type.
   */
  public function getRuleType(): string;

  /**
   * Gets the pattern value.
   *
   * @return string
   *   A regular expression, or an exact string, to match against a value.
   */
  public function getPattern(): string;

  /**
   * Gets the pattern type.
   *
   * @return int
   *   The pattern type.
   */
  public function getPatternType(): int;

  /**
   * Gets the forms to which the restriction applies.
   *
   * @return array
   *   The forms to which the restriction applies.
   */
  public function getForms(): array;

  /**
   * Gets the no_expiration value.
   *
   * @return bool
   *   The no_expiration value, TRUE when the stored expiration time is ignored,
   *   FALSE otherwise.
   */
  public function expires(): bool;

  /**
   * Gets the expiration time.
   *
   * @return int|null
   *   The expiration time.
   */
  public function getExpiration(): ?int;

}
