<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUndefinedNamespaceInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUnused */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions;

use Drupal\user_restrictions\Plugin\UserRestrictionTypeInterface;

/**
 * Defines the interface for the UserRestrictionTypeManager.
 */
interface UserRestrictionTypeManagerInterface {

  /**
   * Gets a list of all the registered user restriction types.
   *
   * @return \Drupal\user_restrictions\Plugin\UserRestrictionTypeInterface[]
   *   A list of user restriction types.
   */
  public function getTypes(): array;

  /**
   * Gets a single plugin instance.
   *
   * @param string $id
   *   The plugin ID.
   *
   * @return \Drupal\user_restrictions\Plugin\UserRestrictionTypeInterface
   *   The plugin instance.
   */
  public function getType(string $id): UserRestrictionTypeInterface;

  /**
   * Gets a list of plugin names for option lists.
   *
   * @return array
   *   A list of plugin names, keyed by plugin ID.
   */
  public function getTypesAsOptions(): array;

}
