<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUndefinedNamespaceInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUnused */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions;

/**
 * Defines the UserRestrictionManager interface.
 */
interface UserRestrictionsManagerInterface {

  /**
   * Checks if a given data matches any restriction.
   *
   * @param array $data
   *   The data to check.
   * @param string $form_id
   *   The form to which the restriction is applied.
   *
   * @return bool
   *   TRUE if the data matches a restriction, FALSE otherwise.
   */
  public function matchesRestrictions(array $data, string $form_id = ''): bool;

  /**
   * Deletes expired rules.
   *
   * @return $this
   */
  public function deleteExpiredRules(): static;

  /**
   * Gets all the error messages.
   *
   * @return array
   *   A list of error messages, keyed by the restriction type.
   */
  public function getErrors(): array;

}
