<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUnused */
/** @noinspection PhpUnusedParameterInspection */
/** @noinspection PhpFullyQualifiedNameUsageInspection */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions\Form;

use Drupal\Core\Entity\EntityConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Url;

/**
 * Provides the user restriction enable form.
 */
class RestrictionEnableForm extends EntityConfirmFormBase {

  /**
   * {@inheritdoc}
   */
  public function getQuestion(): TranslatableMarkup {
    return $this->t('Are you sure you want to enable the user restriction %label?', ['%label' => $this->entity->label()]);
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl(): Url {
    return new Url('entity.user_restriction.collection');
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText(): TranslatableMarkup {
    return $this->t('Enable');
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription(): TranslatableMarkup {
    return $this->t('This will make the %label user restriction available.', ['%label' => $this->entity->label()]);
  }

  /**
   * {@inheritdoc}
   *
   * @throws \Drupal\Core\Entity\EntityStorageException
   *   An error occurred while saving the user restriction.
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    /** @var \Drupal\user_restrictions\Entity\UserRestriction $restriction */
    $restriction = $this->entity;

    $restriction->enable()->save();
    $this->messenger()->addMessage($this->t('Enabled user restriction %label.', ['%label' => $restriction->label()]));
    $form_state->setRedirectUrl($this->getCancelUrl());
  }

}
