<?php

namespace Drupal\user_restrictions\Form;

use Drupal\Core\Form\FormStateInterface;

/**
 * Form to add a new user restriction.
 */
class UserRestrictionsAddForm extends UserRestrictionsFormBase {

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    parent::submitForm($form, $form_state);
    $this->messenger()
      ->addStatus($this->t('User restriction was created for %label.', ['%label' => $this->entity->label()]));
    // Redirect to the user restriction collection page.
    $form_state->setRedirect('entity.user_restriction.collection');
  }

  /**
   * {@inheritdoc}
   */
  public function actions(array $form, FormStateInterface $form_state): array {
    $actions = parent::actions($form, $form_state);
    $actions['submit']['#value'] = $this->t('Create new user restriction');

    return $actions;
  }

}
