<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUndefinedNamespaceInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUnused */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions\Plugin\UserRestrictionType;

use Drupal\Core\Entity\EntityMalformedException;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\user_restrictions\Attribute\UserRestrictionType;
use Drupal\user_restrictions\UserRestrictionInterface;

/**
 * Defines a restriction type by email.
 */
#[UserRestrictionType(
  id: 'mail',
  label: new TranslatableMarkup('Email'),
  weight: 0,
)]
class Email extends UserRestrictionTypeBase {

  /**
   * The users email address.
   *
   * @var string
   */
  protected string $mail = '';

  /**
   * {@inheritdoc}
   */
  public function matches(array $data, string $form_id = ''): false|UserRestrictionInterface {
    if (!isset($data['mail'])) {
      return FALSE;
    }

    $this->mail = $data['mail'];

    /** @var \Drupal\user_restrictions\UserRestrictionInterface $restriction */
    if ($restriction = $this->matchesValue($this->mail, $form_id)) {
      try {
        $this->logger->notice(
          'Restricted email %mail matching %restriction has been blocked.', [
            '%mail' => $this->mail,
            '%restriction' => $restriction->label(),
            'link' => $restriction->toLink($this->t('Edit restriction'), 'edit-form'),
          ]);
      }
      catch (EntityMalformedException) {
        // Ignore the exception, which was thrown while logging a notice
        // message.
      }
    }

    return $restriction;
  }

  /**
   * {@inheritdoc}
   */
  public function getErrorMessage(): TranslatableMarkup {
    return $this->t(
      'The email %mail is reserved, and cannot be used.',
      ['%mail' => $this->mail]
    );
  }

}
