<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUndefinedNamespaceInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUnused */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions\Plugin\UserRestrictionType;

use Drupal\Core\Entity\EntityMalformedException;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\user_restrictions\Attribute\UserRestrictionType;
use Drupal\user_restrictions\UserRestrictionInterface;

/**
 * Defines a restriction type by username.
 */
#[UserRestrictionType(
  id: 'name',
  label: new TranslatableMarkup('Username'),
  weight: -10,
)]
class Name extends UserRestrictionTypeBase {

  /**
   * The username.
   *
   * @var string
   */
  protected string $name = '';

  /**
   * {@inheritdoc}
   */
  public function matches(array $data, string $form_id = ''): false|UserRestrictionInterface {
    if (!isset($data['name'])) {
      return FALSE;
    }

    $this->name = $data['name'];

    /** @var \Drupal\user_restrictions\UserRestrictionInterface $restriction */
    if ($restriction = $this->matchesValue($this->name, $form_id)) {
      try {
        $this->logger->notice(
          'Restricted name %name matching %restriction has been blocked.', [
            '%name' => $this->name,
            '%restriction' => $restriction->label(),
            'link' => $restriction->toLink($this->t('Edit restriction'), 'edit-form'),
          ]);
      }
      catch (EntityMalformedException) {
        // Ignore the exception, which was thrown while logging a notice
        // message.
      }
    }

    return $restriction;
  }

  /**
   * {@inheritdoc}
   */
  public function getErrorMessage(): TranslatableMarkup {
    return $this->t(
      'The name %name is reserved, and cannot be used.',
      ['%name' => $this->name]
    );
  }

}
