<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUndefinedNamespaceInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUnused */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions\Plugin;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\user_restrictions\UserRestrictionInterface;

/**
 * Defines the interface for UserRestrictionType plugins.
 */
interface UserRestrictionTypeInterface extends ContainerFactoryPluginInterface {

  /**
   * Checks if the given data matches the restriction.
   *
   * @param array $data
   *   Data to check.
   * @param string $form_id
   *   The form to which the restriction is applied.
   *
   * @return false|\Drupal\user_restrictions\UserRestrictionInterface
   *   The restriction entity if the value matches one of the restrictions,
   *   FALSE otherwise.
   */
  public function matches(array $data, string $form_id): false|UserRestrictionInterface;

  /**
   * Gets the list of regular expression patterns for the type.
   *
   * @return string[]
   *   Array with regular expression patterns.
   */
  public function getPatterns(): array;

  /**
   * Gets the plugin label.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup
   *   The plugin label.
   */
  public function getLabel(): TranslatableMarkup;

  /**
   * Gets the error message shown when the entered value is not allowed.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup
   *   The error message.
   */
  public function getErrorMessage(): TranslatableMarkup;

}
