<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpFullyQualifiedNameUsageInspection */
/** @noinspection PhpUndefinedNamespaceInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUnused */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\user_restrictions;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\user_restrictions\Plugin\UserRestrictionTypeInterface;

/**
 * Manages user restriction type plugins.
 *
 * @see hook_user_restriction_type_info_alter()
 * @see \Drupal\user_restrictions\Annotation\UserRestrictionType
 * @see \Drupal\user_restrictions\Plugin\UserRestrictionTypeInterface
 * @see \Drupal\user_restrictions\Plugin\UserRestrictionType\UserRestrictionTypeBase
 * @see plugin_api
 */
class UserRestrictionTypeManager extends DefaultPluginManager implements UserRestrictionTypeManagerInterface {

  //phpcs:disable Drupal.Files.LineLength.TooLong

  /**
   * Constructs a new \Drupal\user_restrictions\UserRestrictionTypeManager instance.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   The cache backend.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler.
   */
  public function __construct(
    \Traversable $namespaces,
    CacheBackendInterface $cache_backend,
    ModuleHandlerInterface $module_handler,
  ) {
    parent::__construct(
      'Plugin/UserRestrictionType',
      $namespaces,
      $module_handler,
      'Drupal\user_restrictions\Plugin\UserRestrictionTypeInterface',
      'Drupal\user_restrictions\Attribute\UserRestrictionType',
    );
    $this->alterInfo('user_restriction_type_info');
    $this->setCacheBackend($cache_backend, 'user_restriction_type_plugins');
  }

  //phpcs:enable

  /**
   * {@inheritdoc}
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   *   An error happened when creating a plugin instance.
   */
  public function getTypes(): array {
    $instances = &drupal_static(__FUNCTION__, []);

    if (empty($instances)) {
      // Get registered plugins.
      $plugins = $this->getDefinitions();

      // Sort plugins by weight.
      uasort($plugins, ['Drupal\Component\Utility\SortArray', 'sortByWeightElement']);

      foreach ($plugins as $plugin_id => $plugin) {
        $instances[$plugin_id] = $this->createInstance($plugin_id, $plugin);
      }
    }

    return $instances;
  }

  /**
   * {@inheritdoc}
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   *   An error happened when creating a plugin instance.
   */
  public function getType(string $id): UserRestrictionTypeInterface {
    $instances = $this->getTypes();
    return $instances[$id];
  }

  /**
   * {@inheritdoc}
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   *   An error happened when creating a plugin instance.
   */
  public function getTypesAsOptions(): array {
    /** @var \Drupal\user_restrictions\Plugin\UserRestrictionTypeInterface $type */
    return array_map(fn($type) => $type->getLabel(), $this->getTypes());
  }

}
