# User Status Switch

## Overview

This module adds a convenient toggle switch to the user listing page, allowing administrators to quickly activate or block users without having to open each user profile individually.

## Problem Solved

In standard Drupal, changing a user's status requires:
1. Opening the user edit form
2. Scrolling to find the "Status" radio buttons
3. Selecting "Active" or "Blocked"
4. Saving the user
5. Returning to the People listing

This module streamlines this workflow by adding an on/off toggle switch directly in the People listing table.

## Features

- **Quick Toggle**: One-click activate/block from the People listing
- **Visual Feedback**: Modern toggle switch with clear active/blocked states
- **AJAX-Powered**: Updates happen instantly without page reload
- **Permission-Aware**: Only shows for users with administration permissions
- **Success Messages**: Confirms each status change
- **Accessible**: Keyboard-friendly and screen reader compatible
- **Responsive**: Works on mobile and desktop
- **Compatible**: Works with Drupal 9, 10, and 11

## Installation

### Via Composer (Recommended)

```bash
composer require drupal/user_status_switch
drush en user_status_switch
```

### Manual Installation

1. Download the module
2. Place it in `/modules/custom/user_status_switch`
3. Enable it: `drush en user_status_switch`
4. Or enable via UI: Admin → Extend → Enable "User Status Switch"

## Usage

### Automatic Setup

Once enabled, the module automatically adds a "Quick Status" field to the default People view (`/admin/people`).

### Manual Setup (Optional)

If you want to add the toggle to a custom user listing view:

1. Go to Structure → Views
2. Edit your user listing view
3. Add a new field: "Quick User Status Switch"
4. Save the view

The toggle will now appear in your user listing!

## How It Works

1. **Toggle Switch**: Click the switch to change status
2. **AJAX Request**: The module sends a secure request to update the user status
3. **Instant Update**: The user status changes without page reload
4. **Visual Confirmation**: The toggle updates and a success message appears

## Requirements

- Drupal 9.4+, 10.x, or 11.x
- User module (core)
- Views module (core)

## Permissions

The toggle respects Drupal's permission system:
- Users must have the "Administer users" permission to see and use the toggle
- Requires "Administer users" permission for the toggle route

## Technical Details

### Architecture

- **Views Field Plugin**: Renders the toggle in Views
- **Controller**: Handles AJAX requests to update user status
- **CSRF Protection**: Secure token-based authentication
- **Drupal Messages**: Uses core messaging system for feedback

### Files Structure

```
user_status_switch/
├── src/
│   ├── Controller/
│   │   └── UserStatusSwitchController.php
│   └── Plugin/
│       └── views/
│           └── field/
│               └── UserStatusSwitchField.php
├── templates/
│   └── user-status-switch.html.twig
├── js/
│   └── user-toggle.js
├── css/
│   └── user-toggle.css
├── user_status_switch.info.yml
├── user_status_switch.install
├── user_status_switch.module
├── user_status_switch.routing.yml
└── user_status_switch.libraries.yml
```

## Customization

### Styling

You can override the default styles by adding CSS to your theme:

```css
.user-status-switch {
  /* Your custom styles */
}
```

### Template Override

Copy `user-status-switch.html.twig` to your theme's templates directory and customize as needed.

## Troubleshooting

### Toggle doesn't appear
- Ensure the module is enabled
- Check that you have "Administer users" permission
- Verify the field is added to your view

### Toggle doesn't work
- Check browser console for JavaScript errors
- Verify CSRF token is being generated
- Ensure you have "Administer users" permission

### Status doesn't update
- Check Drupal logs for errors
- Verify database connection

## Security

- **CSRF Protection**: All requests are protected with CSRF tokens
- **Permission Checks**: Validates "Administer users" permission before any update
- **Error Handling**: Graceful error handling prevents data corruption

## Performance

- **Lightweight**: Minimal JavaScript and CSS
- **AJAX**: No page reloads required
- **Efficient**: Only loads on pages with the toggle field
- **Optimized**: Uses Drupal's built-in caching

## Roadmap

Future enhancements may include:
- Bulk toggle for multiple users
- Keyboard shortcuts
- Customizable toggle styles

## Maintainers

- nikhileshpaul - https://www.drupal.org/u/nikhileshpaul

## License

GPL-2.0-or-later

## Support

- **Issue Queue**: https://www.drupal.org/project/issues/user_status_switch
- **Project Page**: https://www.drupal.org/project/user_status_switch

## Credits

Developed to improve user management workflow efficiency in Drupal.
