<?php

namespace Drupal\user_status_switch\Plugin\views\field;

use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Field handler to display quick user status switch.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("user_status_switch_field")
 */
class UserStatusSwitchField extends FieldPluginBase
{

    /**
     * {@inheritdoc}
     */
    public function query()
    {
        // Leave empty to avoid a query on this field.
    }

    /**
     * {@inheritdoc}
     */
    public function render(ResultRow $values)
    {
        $user = $this->getEntity($values);

        if (!$user || !$this->view->getUser()->hasPermission('administer users')) {
            return [];
        }

        // Generate CSRF token for the specific route.
        $path = '/admin/people/toggle-status/' . $user->id();
        $token = \Drupal::csrfToken()->get($path);

        $build = [
            '#theme' => 'user_status_switch',
            '#user_id' => $user->id(),
            '#status' => $user->isActive(),
            '#csrf_token' => $token,
        ];

        $build['#attached']['library'][] = 'user_status_switch/toggle';

        return $build;
    }

}
