/**
 * @file
 * Attaches the behaviors for the Usercentrics module.
 */

(($, Drupal, once, drupalSettings) => {
  /**
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Adds behaviors for usercentrics module.
   */
  Drupal.behaviors.usercentrics = {
    attach(context) {
      const buttonLabel = Drupal.t(
        'Manage consents',
        {},
        { context: 'usercentrics' },
      );
      const buttonHtml = $(
        `<button id="uc_toggle_dialog" aria-label="${buttonLabel}" title="${buttonLabel}" type="button" class="uc_toggle_dialog uc_toggle_dialog_override" rel="open-consent-manager">${buttonLabel}</button>`,
      );
      $(buttonHtml).on('click', (event) => {
        event.preventDefault();
        /* global UC_UI */
        UC_UI.showFirstLayer();
      });
      if (
        typeof drupalSettings.usercentrics !== 'undefined' &&
        typeof drupalSettings.usercentrics.logoPath !== 'undefined'
      ) {
        buttonHtml.css(
          'background-image',
          `url(${drupalSettings.usercentrics.logoPath})`,
        );
      }
      $('body', context).append(buttonHtml);
    },
  };

  Drupal.behaviors.userCentricsBehavior = {
    myObserver: false,
    attach: function (context, settings) {
      // Create observer only once.
      if (this.myObserver) {
        return;
      }

      // Create observer to track new script-nodes and call Drupal.attachBehaviors() after loading.
      var MutationObserver    = window.MutationObserver || window.WebKitMutationObserver;
      var obsConfig           = { childList: true, characterData: true, attributes: true, subtree: true };
      this.myObserver          = new MutationObserver(mutationHandler);
      this.myObserver.observe(document, obsConfig);

      function mutationHandler(mutationRecords) {
        mutationRecords.forEach(function(mutation) {
          var nodes = $(mutation.addedNodes);
          if (nodes.length > 0) {
            node = $(nodes[0]);
            if (node.is('script') && node.attr('type') == 'text/javascript') {
              $(once('uc-script', node)).bind('load', function() {
                console.log('UC: ' + $(this).attr('src') + ' loaded.');
                Drupal.attachBehaviors();
              });
            }
          }
        });
      }
    }
  };

})(jQuery, Drupal, once, drupalSettings);