(function ($, Drupal, once) {
  Drupal.behaviors.usernameSuggestions = {
    attach: function (context, settings) {
      once('usernameSuggestions', '#edit-name', context).forEach(function (element) {
        var $input = $(element);
        var $emailInput = $('#edit-mail');
        var $suggestionsContainer = $('<div id="username-suggestions" aria-live="polite"></div>').insertAfter($input);

        // Debounce function to limit the frequency of AJAX calls
        function debounce(func, delay) {
          var timeout;
          return function () {
            var context = this, args = arguments;
            clearTimeout(timeout);
            timeout = setTimeout(function () {
              func.apply(context, args);
            }, delay);
          };
        }

        // Function to fetch suggestions
        function fetchSuggestions(username, email) {
          if (username) {
            $.ajax({
              url: Drupal.url('username-suggestions/ajax'),
              type: 'GET',
              data: { name: username, mail: email },
              success: function (data) {
                var suggestionsHtml = '<ul role="listbox">';
                if (data.length > 0) {
                  $.each(data, function (index, suggestion) {
                    suggestionsHtml += '<li class="suggestion-item" role="option">' + suggestion + '</li>';
                  });
                } else {
                  suggestionsHtml += '<li>No suggestions available.</li>';
                }
                suggestionsHtml += '</ul>';

                // Show the suggestions container with the fetched suggestions
                $suggestionsContainer.html(suggestionsHtml).show();
              },
              error: function () {
                $suggestionsContainer.html('<p class="error">An error occurred while fetching suggestions.</p>').show();
              }
            });
          } else {
            $suggestionsContainer.hide();
          }
        }

        // Handle input event with debounce
        $input.on('input', debounce(function () {
          var username = $(this).val();
          var email = $emailInput.val();
          fetchSuggestions(username, email);
        }, 300));

        // Handle click on suggestion item
        $suggestionsContainer.on('click', '.suggestion-item', function () {
          var selectedSuggestion = $(this).text();
          $input.val(selectedSuggestion);
          $suggestionsContainer.hide();
        });

        // Close suggestions when clicking outside
        $(document).on('click', function (event) {
          if (!$(event.target).closest('#edit-name, #username-suggestions').length) {
            $suggestionsContainer.hide();
          }
        });
      });
    }
  };
})(jQuery, Drupal, once);
