<?php

namespace Drupal\username_suggestions\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class initialization.
 */
class UsernameSuggestionsSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['username_suggestions.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'username_suggestions_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('username_suggestions.settings');

    $form['username_suggestions_rules'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Suggestion Rules'),
      '#default_value' => $config->get('username_suggestions_rules'),
      '#description' => $this->t('Add suggestion rules, one per row. Available Tokens: [username], [email-firstpart].'),
      '#required' => TRUE,
    ];

    $form['username_suggestions_max'] = [
      '#type' => 'number',
      '#title' => $this->t('Maximum Allowed Suggestions'),
      '#default_value' => $config->get('username_suggestions_max'),
      '#description' => $this->t('Limit the number of suggestions shown.'),
      '#min' => 1,
      '#max' => 5,
      '#required' => TRUE,
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('username_suggestions.settings')
      ->set('username_suggestions_rules', $form_state->getValue('username_suggestions_rules'))
      ->set('username_suggestions_max', $form_state->getValue('username_suggestions_max'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
