# 🚀 UX Enhanced Autocomplete

Enhances the user experience of entity autocomplete fields by displaying additional contextual information.

## ✨ Features

- **Two-line display**: Title on first line, additional information on second line
- **Contextual information**: Entity type, ID, date, and author
- **Flexible configuration**: Customizable options via administration interface
- **Vertical scrolling**: Height limitation with scroll to prevent page extension
- **Multi-entity support**: Compatible with nodes and taxonomy terms

## 📦 Installation

Install like any other contributed Drupal module using Composer:

```bash
composer require drupal/ux_enhanced_autocomplete
drush en ux_enhanced_autocomplete
drush cr
```

## ⚙️ Configuration

Access configuration via:
**Administration > Configuration > User interface > UX Enhanced Autocomplete**

Or directly at: `/admin/config/user-interface/ux-enhanced-autocomplete`

Available options:
- Maximum number of results
- Minimum search length
- Information display (type, ID, date, author)
- Formatting and colors
- Title truncation

## 🎯 Usage

The module automatically activates on all entity autocomplete fields (nodes and taxonomy terms). No additional configuration is required.

## 🔧 Compatibility

- Drupal 10.x / 11.x
- PHP 8.1 or higher (required for match expressions and typed constants)
- Supported entity types: `node`, `taxonomy_term`