Feature: Content Structure - Landing (Layout Builder) Pages - Check to add sections and choose layouts for sections
      As a logged in user with a permission to mange Landing (Layout Builder) pages
      I want to be able to add sections with any layouts to the page
      So that the "Landing (Layout Builder) page" will show up having the listed section with their content

  @javascript @local @development @staging @production
  Scenario: Check if a user with a permission to manage Landing page (Layout Builder) content type can add sections with any layouts to the page
    Given I am a logged in user with the "Site admin" user
     When I go to "/node/add/landing_page_lb"
      And wait
     Then I should see "Create Landing page (Layout Builder)"
     When I fill in "Test Landing page (Layout Builder)" for "Title"
      And I fill in "Test Landing page (Layout Builder) description" for "Page description"
      And I select "published" from "edit-moderation-state-0-state--2"
      And I press the "Save as" button
      And wait
     Then I should see "Landing page (Layout Builder) Test Landing page (Layout Builder) has been created"
      And I should see "You are editing the layout for this Landing page (Layout Builder) content item."
     When I scroll to the bottom of the page
      And I wait 2s
     Then I should see "Add section at end of layout"
     When I click "Add section at end of layout"
      And I wait for AJAX to finish
      And I wait 2s
     Then I should see "Choose a layout for this section"
      And I should see "Bootstrap 1 Col"
      And I should see "Bootstrap 2 Cols"
      And I should see "Bootstrap 3 Cols"
      And I should see "Bootstrap 4 Cols"
      And I should not see "Bootstrap 5 Cols"
      And I should see "Bootstrap 6 Cols"
      And I should not see "Bootstrap 7 Cols"
      And I should not see "Bootstrap 8 Cols"
      And I should not see "Bootstrap 9 Cols"
      And I should not see "Bootstrap 10 Cols"
      And I should not see "Bootstrap 11 Cols"
      And I should not see "Bootstrap 12 Cols"
     When I scroll to the top of the page
      And I wait 4s
      And I press the "Save layout" button
      And wait
      And I wait 2s
     Then I should see "The layout override has been saved."
      And I should see "Test Landing page (Layout Builder)"

  @javascript @local @development
  Scenario: Check that Site admins can add a one coloumn section and add a Rich text block in the section
    Given I am a logged in user with the "Site admin" user
     When I go to "/admin/content"
      And wait
     Then I should see "Content"
     When I fill in "Test Landing page (Layout Builder)" for "Title"
      And I press the "Filter" button
      And wait 3s
     Then I should see "Test Landing page (Layout Builder)"
     When I click "Test Landing page (Layout Builder)"
      And wait
     Then I should see "Test Landing page (Layout Builder)"
     When I open the top bar page actions menu
      And I wait for AJAX to finish
      And I wait 2s
      And I should see "Layout"
     When I click "Layout"
      And wait
     Then I should see "You are editing the layout for this Landing page (Layout Builder) content item."
     When I scroll to the bottom of the page
      And I wait 2s
     Then I should see "Add section at end of layout"
     When I add a basic section at the end of layout
      And I scroll to the bottom of the page
      And I save the section
      And I wait for AJAX to finish
      And I wait 2s
     Then I should see "Add block in Section 2, Col 1 region"

     When I click "Add block in Section 2, Col 1 region"
      And I wait for AJAX to finish
      And I wait 2s
     Then I should see "Create content block"
     When I click "Create content block"
      And I wait for AJAX to finish
      And I wait 2s
     Then I should see "Rich text"
     When I click "Rich text"
      And I wait for AJAX to finish
      And I wait 2s
     Then I should see "Configure block"
     When I check the box "Display title"
      And I fill in "Rich text in 1 col section" for "Title"
      And I fill in the rich text editor field "Body" with "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean lacinia sapien quis tempor placerat. Nulla faucibus rhoncus est, vel malesuada nisl pulvinar ut. Sed vulputate est nec dui finibus, tempus lobortis quam mattis. Fusce facilisis ut nunc ut scelerisque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed aliquet purus vitae augue lobortis accumsan ut nec nulla. Cras nisi mauris, gravida ac"
      And I press the "Add block" button
      And I wait for AJAX to finish
      And I wait 2s
     Then I should see "Rich text in 1 col section"

     When I scroll to the top of the page
      And I wait 4s
      And I press the "Save layout" button
      And wait
     Then I should see "The layout override has been saved."
      And I should see "Test Landing page (Layout Builder)"
      And I should see "Rich text in 1 col section"
