<?php

/**
 * @file
 * Contains varbase_admin_update_10###(s) hook updates.
 */

use Vardot\Entity\EntityDefinitionUpdateManager;
use Vardot\Installer\ModuleInstallerFactory;
use Drupal\Core\Recipe\Recipe;
use Drupal\Core\Recipe\RecipeRunner;

/**
 * Issue #3398817: Add Views Date Filter ~1.0.0 module.
 *
 * Enable it and change default configs for Date Filters.
 */
function varbase_admin_update_100001() {
  if (!\Drupal::moduleHandler()->moduleExists('date_filter')) {
    \Drupal::service('module_installer')->install(['date_filter'], FALSE);

    $managed_configs = [
      'views.view.content',
      'views.view.user_admin_people',
    ];
    ModuleInstallerFactory::importConfigsFromList('varbase_admin', $managed_configs, 'config/optional');

    // Entity updates to clear up any mismatched entity and/or field definitions
    // And Fix changes were detected in the entity type and field definitions.
    \Drupal::classResolver()
      ->getInstanceFromDefinition(EntityDefinitionUpdateManager::class)
      ->applyUpdates();
  }
}

/**
 * Issue #3426342: Add Gin Everywhere ~1 module to Varbase Admin.
 *
 * As part of enhancing Editorial UX for taxonomy and term management.
 */
function varbase_admin_update_100002() {
  if (!\Drupal::moduleHandler()->moduleExists('gin_everywhere')) {
    \Drupal::service('module_installer')->install(['gin_everywhere'], FALSE);
  }
}

/**
 * Issue #3426347: Add Taxonomy Manager ~2 module to Varbase Admin.
 *
 * As part of enhancing Editorial UX for taxonomy and term management.
 */
function varbase_admin_update_100003() {
  if (!\Drupal::moduleHandler()->moduleExists('taxonomy_manager')) {
    $module_path = Drupal::service('module_handler')->getModule('varbase_admin')->getPath();
    $recipe = Recipe::createFromDirectory($module_path . '/recipes/updates/varbase_admin_update_100003');
    RecipeRunner::processRecipe($recipe);
  }
}

/**
 * Issue #3426299: Add the Gin Admin theme to Varbase Core.
 *
 * And deprecate Vartheme Claro theme, switch to the Gin Admin theme with default Varbase recipe
 */
function varbase_admin_update_100004() {
  $module_path = Drupal::service('module_handler')->getModule('varbase_admin')->getPath();
  $recipe = Recipe::createFromDirectory($module_path . '/recipes/updates/varbase_admin_update_100004');
  RecipeRunner::processRecipe($recipe);

  // Uninstall the deprecated Vartheme Claro theme.
  \Drupal::service('theme_installer')->uninstall(['vartheme_claro']);
}

/**
 * Issue #3443115: Update the list of responsive devices in Preview Page layout.
 */
function varbase_admin_update_100005() {
  $module_path = Drupal::service('module_handler')->getModule('varbase_admin')->getPath();
  $recipe = Recipe::createFromDirectory($module_path . '/recipes/updates/varbase_admin_update_100005');
  RecipeRunner::processRecipe($recipe);
}

/**
 * Issue #3505583: Enable the new administration Navigation module.
 *
 * And remove Admin Toolbar & Admin Toolbar Extra Tools for improved admin UX.
 */
function varbase_admin_update_100006() {

  if (!\Drupal::moduleHandler()->moduleExists('navigation')) {
    $module_path = Drupal::service('module_handler')->getModule('varbase_admin')->getPath();
    $recipe = Recipe::createFromDirectory($module_path . '/recipes/updates/varbase_admin_update_100006');
    RecipeRunner::processRecipe($recipe);
  }

  if (\Drupal::moduleHandler()->moduleExists('admin_toolbar_tools')) {
    \Drupal::service('module_installer')->uninstall(['admin_toolbar_tools', 'admin_toolbar'], FALSE);
  }

  if (\Drupal::moduleHandler()->moduleExists('admin_toolbar')) {
    \Drupal::service('module_installer')->uninstall(['admin_toolbar'], FALSE);
  }
}
