<?php

namespace Drupal\vertex_ai_search\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a VertexConfigurableJavaScriptPlugin type annotation object.
 *
 * VertexConfigurableJavaScriptPlugin classes define keys processor plugins for
 * vertex_ai_search module.
 *
 * @see VertexConfigurableJavaScriptPluginBase
 *
 * @ingroup vertex_ai_search
 *
 * @Annotation
 */
class VertexConfigurableJavaScriptPlugin extends Plugin {

  /**
   * A unique identifier for the vertex search keys processor plugin.
   *
   * @var string
   */
  public $id;

  /**
   * The title for the vertex search keys processor plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $title;

}
