<?php

namespace Drupal\vertex_ai_search\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\search\SearchPageRepositoryInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines an access controller for custom Vertex search pages.
 */
class VertexAISearchAccessController extends ControllerBase {

  /**
   * Search Page Repository Manager.
   *
   * @var \Drupal\search\SearchPageRepositoryInterface
   */
  protected $searchPageRepository;

  /**
   * Constructs a new search controller.
   *
   * @param \Drupal\search\SearchPageRepositoryInterface $search_page_repository
   *   Search page repository manager.
   */
  public function __construct(
    SearchPageRepositoryInterface $search_page_repository,
  ) {
    $this->searchPageRepository = $search_page_repository;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('search.search_page_repository')
    );
  }

  /**
   * Creates permissions for the Vertex AI Custom Search Pages.
   */
  public function retrieveVertexPagePermissions() {
    $permissions = [];

    // Generate permissions for each Vertex AI Search Plugin page.
    $searchPages = $this->searchPageRepository->getActiveSearchPages();

    foreach ($searchPages as $searchPage) {
      if ($searchPage->get('plugin') === 'vertex_ai_search') {
        $id = $searchPage->id();
        $permissions += [
          "use $id custom search page" => [
            'title' => $this->t('Use %type Custom Search Page',
              ['%type' => $searchPage->label()]),
            'description' => 'Permission to use this vertex-based custom search page',
          ],
        ];
      }
    }

    return $permissions;
  }

}
