<?php

namespace Drupal\vertex_ai_search\Plugin;

/**
 * Provides an interface for a Vertex Search Results plugin.
 */
interface VertexSearchResultsPluginInterface {

  /**
   * Retrieves manually specified results that accompany search results.
   *
   * @param array $search_page_config
   *   Array containing configuration of relevant custom search page.
   * @param array $search_parameters
   *   Array containing parameters of the search.
   *
   * @return array
   *   Array of curated results that can be added to retrieved results.
   */
  public function retrieveCuratedResults(array $search_page_config, array $search_parameters);

  /**
   * Blends curated content together with search results.
   *
   * @param array $search_page_config
   *   Array containing configuration of relevant custom search page.
   * @param array $search_parameters
   *   Array containing parameters of the search.
   * @param array $search_results
   *   The search results of a search page.
   * @param array $curated_content
   *   The content to be merged with the search results.
   *
   * @return array
   *   Array of retrieved results - including curated_content.
   */
  public function manipulatePageResults(array $search_page_config, array $search_parameters, array $search_results, array $curated_content);

  /**
   * Retrieves curated content and returns a modified array of search results.
   *
   * Keep for back-compatibility.
   *
   * @param string $keyword
   *   String used for search query.
   * @param array $searchResults
   *   The search results of a search page.
   * @param string $search_page_id
   *   The id of the custom search page.
   *
   * @return array
   *   An array of retrieved results - including curated_content.
   */
  public function modifyPageResults(string $keyword, array $searchResults, string $search_page_id);

}
