<?php

namespace Drupal\vertex_ai_search\Service\Decorator;

use Drupal\Core\Pager\Pager;

/**
 * A value object that represents a pager.
 */
class VertexPager extends Pager {

  /**
   * The total number of Vertex Results.
   *
   * @var int
   */
  protected $totalVertexItems;

  /**
   * Pager constructor.
   *
   * @param int $totalVertexItems
   *   The total number of items returned by Vertex.
   * @param int $limit
   *   The maximum number of items per page.
   * @param int $currentPage
   *   The current page.
   */
  public function __construct($totalVertexItems, $limit, $currentPage = 0) {
    $this->totalItems = $totalVertexItems;
    $this->totalVertexItems = $totalVertexItems;
    $this->limit = $limit;
    $this->setTotalPages($this->totalItems, $limit);
    $this->setCurrentPage($currentPage);
  }

  /**
   * Gets the total number of Vertex items.
   *
   * @return int
   *   The total number of Vertex items.
   */
  public function getTotalVertexItems() {
    return $this->totalVertexItems;
  }

}
